
#|____________________________________________________________________
 |
 |  MESSAGE1.lsp 
 |  this file has code defining help items
 |  Copyright (c) 2001 by Forrest W. Young
 |  All rights reserved 
 |
 |  The functions for accessing the messages, panel and chain system should
 |  follow a naming convention. The convention involves several parts:
 |
 |  1) TOPIC and SUBTOPIC names should correspond with message names, i.e.,
 |     if name is Using The Menus, message function is (using-the-menus)
 |
 |  2) The first subtopic of a topic is the topic summary message
 |
 |  3) When a message makes the panel show, the message's topic and subtopic
 |     items are always highlighted, with subtopic list showing, unless
 |     the message type says no items in which case the panel is only shown.
 |
 |  4) If the message is MSG, then the convention is that following functions 
 |     names imply the indicated actions:
 |     FUNCTION  CONCEPT          MESSAGE  PANEL  I J  CHAIN
 |     MSG++     message chain    yes      no     - -  yes
 |     MSG+      message & panel  yes      yes    i j  no
 |     MSG       message          yes      no     - -  no 
 |     MSG0      summary & panel  yes      yes    i 0  no
 |     MSG-      panel            no       yes    i j  no
 |     MSG--     panel no items   no       yes    - -  no
 |       
 |  5) Note that HELP is irregular
 |       (help)         is defined in lspsrc/help.lsp to expand on
 |                      the lisp and lispstat defintions of (help), leaving
 |                      all previous functionality in tact. It is defined 
 |                      to take an optional argument. If the argument is a 
 |                      SYMBOL - the symbol's documentation string is printed
 |                               in the listener (Xlisp does this0 
 |                      STRING - the string is shown in a ViSta text window
 |                      NIL    - shows the help panel by using (vista-help).
 |     The following are equivalent
 |       (help-) ? (help) (vista-help)
 |                      these all show help panel and basic help message
 |       (help--) (help-panel) (help-topics) and (help-topics-panel)
 |                      these all show the help panel and no help message
 |       (help!)        shows only the basic vista help message, no help panel
 |____________________________________________________________________
 |#


#|________________HELP FUNCTIONS______________________________________|#

(setf  help     "Please Type (help) Instead")
(defun help++ () (window-chain (list '(help!) '(topics))))
(defun help+  () (help-control-panel 0 0 t))
(defun help0  () (help-control-panel 0 0 t))
(defun help-  () (help-control-panel 0 0 nil))
(defun help-- (&optional (topic 0) subtopic help show-vista-at-close (show-dialog-at-startup t)) 
  (help-control-panel topic subtopic help 
                      :choice-to-show-vista-at-close show-vista-at-close
                      :choice-to-show-dialog-again-at-startup show-dialog-at-startup))
(defun excel-help () 
  (help-control-panel 4 0 nil 
                      :choice-to-show-vista-at-close t
                      :choice-to-show-dialog-again-at-startup t))

(defun help-topics-panel () (help-panel))

(set-macro-character
  #\?
  #'(lambda (stream char)
      (declare (ignore char))
      (vista-help)
      (format t "> ~%")
      (force-output)
      (TOP-LEVEL NIL)
      ))
(defun info ()                                         (help-topics))
(defun information-messages ()                         (help-topics))
(defun help-summary ()                                 (help0))
(defun help-panel      (&optional (i 0) (j nil) (s t))   (help-control-panel i j s))
(defun show-help-panel (&optional (i 0) (j 0) (s t))   (help-control-panel i j s))
(defun vista-help      (&optional (i 0) (j 0) (s nil)) (help-control-panel i j s))
(defun help-topics     (&optional (i 0) (j nil) (s nil)) 
  (help-control-panel i j s))

(defun welcoming-messages (&optional (i 0) (j 0) (s t)) (WELCOME-control-panel i j s))

  
;WINDOW CHAINS



(defun welcome++ () (welcome-to-vista++))
(defun welcome+  () (welcome-control-panel 0 0 t))
(defun welcome   () (welcome-message))
(defun welcome-  () (welcome-control-panel 0 0 nil))
(defun welcome-- () (welcome-control-panel nil nil nil))

(defun welcome-to-vista-with-registration ()
  (window-chain 
   (list  '(welcome1-message) '(welcome2-message) '(welcome3-message) '(welcome4-message)
          '(welcome4a-message) '(welcome4b-message) 
	'(welcome5initial-message ) 
          '(welcome6-message))
   '(online-register)))

(defun welcome-to-vista++ ()
  (window-chain (list  '(welcome1-message) '(welcome2-message) '(welcome3-message)
                       '(welcome4-message) '(welcome4a-message) '(welcome4b-message)
                       '(welcome5-message) '(welcome6-message))))


(defun welcome-developer ()
  (window-chain (list  '(personal-message) '(welcome-developer-message)
                       '(appdevel-message) '(sysdevel-message)
                       )
                '(configure-development-environment)))


(defun configure-development-environment ()
  (unless *devel-mode* (devel-mode))
  (setf *install-developer* nil)
  (save-all-prefs)
  (online-register)
  (send *desktop-container* :select-window)
  )

(defun welcome-developer-message  ()
  (file-to-window  (strcat *help-dir-name* "dvlpr.hlp") 
                   (strcat "Welcome to ViSta - The Visual Statistics System")
                   (send *vista* :help-window-object) t nil))

(defun new-in-vista6 ()
  (window-chain (list '(about-version-6) '(new-features))))

(defun using-the-desktop ()
  (window-chain (list '(desktop-help) '(workmap-help) '(desktop-options-help)
                      '(toolbar-help) '(datasheet-help) '(selector-help) '(listener-help))))

(defun using-the-menus ()  (menu-help-without-item-help))

(defun menu-help ()
	(menu-item-help) 
	(menu-help-without-item-help))

(defun entering-data ()
  (window-chain (list '(using-the-datasheet) ;'(using-the-editor)
                      '(importing-data) '(simulating-data) ;'(writing-datacode)
                      )))

(defun manipulating-data ()
  (window-chain (list '(about-the-data-system) '(manipulating-variables)
                      '(the-variable-language) '(the-variable-maker)
                      '(the-data-maker) '(the-datacode-editor))))

(defun animations ()
  (window-chain (list '(vista-movie) '(clock) '(screen-saver-full-screen))))


;MISCELLENEOUS PRELIMINARY FUNCTIONS FOR THE HELP PANEL

(setf on-data-analysis
      (list
       
       " "
       "first, you see your data for what they seem to be"
       "       then, you ask them for the truth -" 
       "                      are you what you seem to me?"
       " "
       "       you see with broad expanse"
       "           yet ask with narrowed power"
       "               you see and ask and see"
       "               and ask and see ... and ask"
       " "
       "with brush you paint the possibilities"
       "       with pen you scribe the probabilities"
       "       for in pictures we find insight"
       "              while in numbers we find strength"
       " "
       "                                    -  forrest w young"))

(setf *zen* on-data-analysis)
(setf zen on-data-analysis)
(setf haiku on-data-analysis)
(defun zen () 
      (twiddle :text haiku :hide-logo t :static t :size '(450 250)
               :title "Seeing Data - Asking Truth - Gaining Insight"))

(setf *help-topics-panel* nil)

(defun data-truth-insight ()
  (let ((h (help (string-list-to-text on-data-analysis))))
   (send h :title "Seeing Data - Asking Truth - Gaining Insight")))

(defun show-screen-saver () (screen-saver))

(defun screen-saver ()
  (send *vista* :screen-saver-on t)
  (send *workmap* :reset-screen-saver)
  (when (or (not *screen-saver*)  
            (send *screen-saver* :showing))
        (setf *screen-saver*  
              (if (send *vista* :screen-saver-clock) 
                  (clock) (haiku)))
        (send *screen-saver* :showing t))
  (defmeth *screen-saver* :close ()
    (send *workmap* :remove-screen-saver) 
    (send self :idle-on nil)
    (send *vista* :screen-saver-on t)
    (send *workmap* :reset-screen-saver)
    (setf *logo* nil)
    (send self :showing nil)
    (call-next-method))
  (send *screen-saver* :screen-saver t)
  (send *screen-saver* :showing nil)
  (send *screen-saver* :transf nil)
  (send *vista* :screen-saver-on nil)
  )
  
(defun screen-saver-full-screen ()
  (send *vista* :screen-saver-full-screen))



#|____ HELP! __________________|#


(defun help! () 
  (file-to-window  (strcat *help-dir-name* "helphelp.hlp") 
                   (strcat "Welcome to ViSta - The Visual Statistics System")
                   (send *vista* :help-window-object) t nil))

(defun topics ()
  (file-to-window  (strcat *help-dir-name* "topics.hlp") 
                   (strcat "Welcome to ViSta - The Visual Statistics System")
                   (send *vista* :help-window-object) t nil))



#|____ welcome-to-vista __________________|#

(defun personal-message ()
  (file-to-window  (strcat *help-dir-name* "personal.hlp") 
                   (strcat "Welcome to ViSta - The Visual Statistics System")
                   (send *vista* :help-window-object) t nil))


(defun welcome-message () 
  (file-to-window (strcat *help-dir-name* "welcome.hlp")
                  (strcat "Welcome to ViSta - The Visual Statistics System")
                  (send *vista* :help-window-object) t nil))

(defun welcome1-message () 
  (file-to-window (strcat *help-dir-name* "welcome1.hlp")
                  (strcat "Welcome to ViSta - The Visual Statistics System")
                  (send *vista* :help-window-object) t nil))

(defun welcome2-message () 
  (file-to-window (strcat *help-dir-name* "welcome2.hlp")
                  (strcat "Welcome to ViSta - The Visual Statistics System")
                  (send *vista* :help-window-object) t nil))

(defun welcome3-message () 
  (file-to-window (strcat *help-dir-name* "welcome3.hlp")
                  (strcat "Welcome to ViSta - The Visual Statistics System")
                  (send *vista* :help-window-object) t nil))

(defun welcome4-message ()
  (help--) 
  (file-to-window (strcat *help-dir-name* "welcome4.hlp")
                  (strcat "Welcome to ViSta - The Visual Statistics System")
                  (send *vista* :help-window-object) t nil))

(defun welcome4a-message ()
  (welcome--) 
  (file-to-window (strcat *help-dir-name* "welcome4-showdialog.hlp")
                  (strcat "Welcome to ViSta - The Visual Statistics System")
                  (send *vista* :help-window-object) t nil))

(defun welcome4b-message ()
  (menu-item-help)
  (file-to-window (strcat *help-dir-name* "welcome4-menuhelp.hlp")
                  (strcat "Welcome to ViSta - The Visual Statistics System")
                  (send *vista* :help-window-object) t nil))

(defun welcome5-message ()
  (file-to-window (strcat *help-dir-name* "welcome5.hlp")
                  (strcat "Welcome to ViSta - The Visual Statistics System")
                  (send *vista* :help-window-object) t nil))



(defun welcome5initial-message ()  
  (file-to-window (strcat *help-dir-name* "welcome5initial.hlp")
                  (strcat "Welcome to ViSta - The Visual Statistics System")
                  (send *vista* :help-window-object) t nil))


(defun welcome6-message () 
  (file-to-window (strcat *help-dir-name* "welcome6.hlp")
                  (strcat "Welcome to ViSta - The Visual Statistics System")
                  (send *vista* :help-window-object) t nil))


(defun why-vista ()
  (file-to-window (strcat *help-dir-name* "why.hlp")
                  (strcat "Welcome to ViSta - The Visual Statistics System")
                  (send *vista* :help-window-object) t nil))

(defun getting-started () 
  (file-to-window  (strcat *help-dir-name* "readings.hlp") 
                   (strcat "Welcome to ViSta - The Visual Statistics System")
                   (send *vista* :help-window-object) t nil))


(defun please-read () (getting-started))
(defun readings    () (getting-started))



(defun about-version-6 (&optional window)
  (file-to-window  (strcat *help-dir-name* "vista-6.hlp") 
                   (strcat "About Version 6")
                   (send *vista* :help-window-object) t nil))

(defun new-features () 
  (file-to-window  (strcat *help-dir-name* "features.hlp") 
                   (strcat "New Features in ViSta 6")
                   (send *vista* :help-window-object) t nil))

(defun known-bugs ()
  (file-to-window  (strcat *help-dir-name* "bug-list.hlp") 
                   (strcat "Known Bugs in ViSta 6")
                   (send *vista* :help-window-object) t nil))

(defun data-truth-insight () 
  (file-to-window  (strcat *help-dir-name* "on-stats.hlp") 
                   (strcat " ")
                   (send *vista* :help-window-object) t nil))

(defun fwy ()
  (file-to-window (strcat *help-dir-name* "fwy.hlp")
                  (strcat "Welcome to ViSta - The Visual Statistics System")
                  (send *vista* :help-window-object) t nil))

(defun fwy-on-statistics () (data-truth-insight))

(defun on-statistics () (zen-movie))

(defun about-statistics ()  (string-list-to-text haiku))


(defun forrest-online ()   (web-help "http://forrest.psych.unc.edu"))
(defun vista-website()     (web-help (strcat *vista-url* "index.html")))
(defun vista-online ()     (web-help (strcat *vista-url* "online/index.html")))
(defun online-help ()      (web-help (strcat *vista-url* "help/index.html")))
(defun online-register ()  (web-help (strcat *vista-url* "register/index.html")))
(defun online-newsgroup () (web-help (strcat *vista-url* "newslist/index.html")))
(defun online-developer () (web-help (strcat *vista-url* "developer/index.html")))
(defun online-updates ()   (web-help (strcat *vista-url* "updates/index.html")))
(defun online-plugins ()   (web-help (strcat *vista-url* "plugins/index.html")))
(defun online-download ()  (web-help (strcat *vista-url* "downloads/index.html")))
(defun online-welcome ()   (web-help (strcat *vista-url* "welcome/index.html")))


#+msdos
(defun web-help (&optional (filename "index.html"))
  (let* ((working-dir (get-working-directory))
         (file-path (if (equal (subseq filename 0 4) "http")
                        filename
                        (strcat *default-path* "html" separator filename)))
         )
    (when *help-window* (send *help-window* :close))
    (when *chain-window* (send *chain-window* :close)) 
    (send *desktop-container* :front-window)
    (unless *browser* (try-to-find-win-browser))
    (unless *browser* 
            (message-dialog (format nil "ViSta cannot find your web browser.~%Please use the next dialog box to locate it."))
          (setf *browser* (open-file-dialog t))
          )
  (cond 
    (*browser* 
     (system (strcat *browser* " "file-path))
    ; (when *help-control-panel* (send *help-control-panel* :show-window))
     (send *desktop-container* :redraw))
    (t
     (post-it (format nil "Your web browser couldn't be found. Please read the information in  ~a " filename))
     ))))

 #-msdos(defun web-help (&optional (filename "welcome-frameset.html"))
           (cond 
             (*show-web-docs* 
              (setf *show-web-docs* nil)
              (vista-message (format nil "NOTE: FOR MORE INFORMATION ABOUT VISTA:~%Please locate and double-click the file READ-ME.HTML in the directory containing the newly installed ViSta software. (The automatic method for running your Web Browser is not yet working in this preview release.)")))
             (t
              (vista-message (format nil
                 "Web features not yet working in this Macintosh Preview version.")))))


#|_using-the-desktop______________________________________|#


(defun workmap-help ()
  (file-to-window  (strcat *help-dir-name* "workmap.hlp") 
                   (strcat "Using The WorkMap")
                   (send *vista* :help-window-object) t nil))

(defun desktop-options-help () 
  (file-to-window  (strcat *help-dir-name* "dsktpopt.hlp") 
                   (strcat "Using The DeskTop Options")
                   (send *vista* :help-window-object) t nil))

(defun toolbar-help ()
  (file-to-window  (strcat *help-dir-name* "toolbar.hlp") 
                   (strcat "Using The WorkMap ToolBar")
                   (send *vista* :help-window-object) t nil))

(defun selector-help ()
  (file-to-window  (strcat *help-dir-name* "selector.hlp") 
                   (strcat"Using The Selector")
                   (send *vista* :help-window-object) t nil))

(defun listener-help ()
  (file-to-window  (strcat *help-dir-name* "listener.hlp") 
                   (strcat "Using The Listener")
                   (send *vista* :help-window-object) t nil))

#|_using-the-menus _______________________________________|#


(defun getting-help () (using-the-menus))
(defun about-menus  () (using-the-menus))

(defun menu-help-without-item-help  () 
  (file-to-window  (strcat *help-dir-name* "menus.hlp") 
                   "Using the Menus"
                   (send *vista* :help-window-object) t nil))

(defun menu-item-on-off-help  () 
  (file-to-window  (strcat *help-dir-name* "menuhelp.hlp") 
                   "Menu Item Help"
                   (send *vista* :help-window-object) t nil))

(defun window-menu ()
  (file-to-window (text-to-file (window-menu-help-text) 
                                (strcat *help-path* "window.hlp"))
                  "Window Menu Help"
                  (send *vista* :help-window-object) t nil))

(defun options-menu ()
  (file-to-window (text-to-file (options-menu-help-text) 
                                (strcat *help-path* "options.hlp"))
                  "Options Menu Help"
                  (send *vista* :help-window-object) t nil))

#|_excel-and-vista_________________________________|#


(defun excel-and-vista () 
  (window-chain (list '(using-excel-and-vista) '(from-excel-to-vista) '(from-vista-to-excel) '(notes-about-using-excel) '(changing-excels-vista-menu))))


(defun using-excel-and-vista () 
 (file-to-window  (strcat *help-dir-name* "excel-and-vista.hlp") 
                   (strcat "Using Excel and ViSta Together")
                   (send *vista* :help-window-object) t nil)) 

(defun from-excel-to-vista ()
  (file-to-window  (strcat *help-dir-name* "excel-to-vista.hlp") 
                   (strcat "Sending Information From Excel To ViSta")
                   (send *vista* :help-window-object) t nil)) 

(defun from-vista-to-excel ()
  (file-to-window  (strcat *help-dir-name* "excel-from-vista.hlp") 
                   (strcat "Sending Data From ViSta to Excel")
                   (send *vista* :help-window-object) t nil)) 

(defun notes-about-using-excel ()
  (file-to-window  (strcat *help-dir-name* "excel.hlp") 
                   (strcat "Notes About Using Excel")
                   (send *vista* :help-window-object) t nil)) 

(defun changing-excels-vista-menu ()
  (file-to-window  (strcat *help-dir-name* "excel-new-menu.hlp") 
                   "Changing Excel's ViSta Menu"
                   (send *vista* :help-window-object) t nil)) 


#|_entering-data______________________________________|#


(defun simulating-data () 
  (file-to-window  (strcat *help-dir-name* "simulate.hlp") 
                   (strcat "Simulating Data")
                   (send *vista* :help-window-object) t nil))

(defun importing-data () 
  (file-to-window  (strcat *help-dir-name* "import-d.hlp") 
                   (strcat "Importing Data")
                   (send *vista* :help-window-object) t nil))

(defun sas2vista () 
  (file-to-window  (strcat *help-dir-name* "sas.hlp") 
                   (strcat "Importing SAS Datasets")
                   (send *vista* :help-window-object) t nil))

(defun using-the-datasheet () 
  (file-to-window  (strcat *help-dir-name* "datashee.hlp") 
                   (strcat "Using the DataSheet")
                   (send *vista* :help-window-object) t nil)) 

(defun using-the-editor () 
  (file-to-window  (strcat *help-dir-name* "editor.hlp") 
                   (strcat "Using the Text Editor")
                   (send *vista* :help-window-object) t nil)) 


#|
 |_manipulating-data______________________________________
 |#

; 1


(defun about-the-data-system ()
  (file-to-window (strcat *help-dir-name* "data-ovr.hlp")
                  "About The Data System" 
                  (send *vista* :help-window-object) t nil))

(defun inputting-data ()
  (file-to-window (strcat *help-dir-name* "data-ovr.hlp") 
        "Inputting Data"(send *vista* :help-window-object) t nil))

(setf making-variables-and-data-help-item
      (send menu-item-proto :new "Inputting Data"
            :action 'variables-and-data))

(defun vartypes-datatypes ()
  (file-to-window (strcat *help-dir-name* "vartypes.hlp")
        "Variable Types and DataTypes" *help-window* t nil))

; 2
(defun manipulating-variables ()
  (file-to-window (strcat *help-dir-name* "manipula.hlp")
        "Manipulating Variables" *help-window* t nil))


; 3

(defun the-variable-language ()
  (file-to-window
        (strcat *help-dir-name* "viva.hlp")
        "ViVa - ViSta's Variable Language" *help-window* t nil))

;4
(defun the-variable-maker ()
  (file-to-window
        (strcat *help-dir-name* "var.hlp")
        "The VARIABLE Maker" *help-window* t nil))

; 5
(defun the-data-maker ()
  (file-to-window 
        (strcat *help-dir-name* "data-obj.hlp") 
        "DATA - The DATA Maker" *help-window* t nil))


(defun data-type-help ()
  (file-to-window (strcat *help-dir-name* "datatype.hlp") 
        "Data Types"(send *vista* :help-window-object) t nil))


; 6
(defun the-datacode-editor ()
      (file-to-window
            (strcat *help-dir-name* "edit-dat.hlp")
            "The DATACODE-editor" *help-window* t nil))

(defun zen-data()(print-zen))

(defun variable-objects() (creating-variables))

(defun Creating-Variables()
  (file-to-window (strcat *help-dir-name* "creating.hlp") 
        "Creating Variables" *help-window* t nil))



#|_ animations ______________________________________|#



(defun vista-movie (&rest args &key (static nil) (margin '(15 45 15 45)))
  (let ((log)(twid))
    (when (and (boundp '*logo*) *logo*) (setf log *logo*))
    (setf twid (apply #'twiddle :static static :margin margin args))
    (defmeth twid :closing-method () 
      (send self :wire-frame nil)
      (send self :disolve :disolve-type (1- (floor (* 3 (uniform-rand 1))))))
    (when log (send log :close) (setf log nil))
    twid))


#|_ on statistics ______________________________________|#

(defun zen-print () (zen-movie :static t :draw-color 'black :back-color 'white))
(defun zen-movie () (poem-cinerama))
(defun poem-movie (&rest args &key (text on-data-analysis) (size '(480 240))
                        (x 70) (y 10) (title "on statistics    -    by forrest w young")
                        (static nil) (margin '(15 45 15 45)))
  (let ((log)(twid))
    (when (and (boundp '*logo*) *logo*) (setf log *logo*))
    (setf twid (apply #'twiddle :text text :static static :size size
                      :x x :y y :title title :margin margin args))
    (defmeth twid :closing-method () 
      (send self :wire-frame nil)
      (send self :disolve :disolve-type (1- (floor (* 3 (uniform-rand 1))))))
    (when log (send log :close) (setf log nil))
    twid))

#|_ about vista  ______________________________________|#

(defun title-complete  ()
  (list ( strcat "         "	*vista-name*) 
        "                   Forrest W. Young"
         " "   " "  " "   *copyright-string* 
	*version-string*
	" "   " "   " "  
        (strcat "            " *vista-website*)
        (strcat "            " *vista-email*)
        (strcat "            " *vista-news* )
	  (strcat "            " *vista-bugs*)))

(defun title  ()
  (list ( strcat "          "	*vista-name*) 
        "                   Forrest  W. Young"
        " "   " "   " "   " "  " "
    	" "   " "   " "   " "  " "
        " "
        (if *devel-mode*
        "When startup fails, closing this window shows listeners."
        "                     visualstats.org")
        ))

(defun printout-TITLE ()
(help (format nil "ViSta: The Visual Statistics System~%~%Copyright  1991-2002 by Forrest W. Young~%Version 7.07.7912 EWD.2002.06.06.7912~%~%web:   www.visualstats.org~%email: listener@visualstats.org~%news:  vista@unc.edu~%bugs:  bugs@visualstats.org")))

(defun PRINTOUT-title ()
  (help "
         ViSta: The Visual Statistics System
      Copyright  1991-2002 by Forrest W. Young

        Version 7.07.7912 EWD.2002.06.06.7912

              web: www.visualstats.org
           email: listener@visualstats.org
              newsgroup: vista@unc.edu
             bugs: bugs@visualstats.org")
  )



(defun print-title ()
  (help-window (string-list-to-text (title)) 
               :title "on data analysis " :color 'white :menu nil))

;old version messes with *logo* value
(defun title-movie (&rest args &key (text (title)) (size '(440 220))
                              (x 25) (y 10) (static nil) (margin '(25 55 25 35)))
  (let ((log)(twid))
    ;(when (and (boundp '*logo*) *logo*) (setf log *logo*))
    (setf twid (apply #'twiddle :text text :static static :size size
                      :x x :y y  :margin margin args))
    ;(setf *logo* twid)
    ;(when log (send log :close) (setf log nil))
    twid))


(defun title-movie (&rest args &key (text (title)) (size '(440 220))
                              (x 25) (y 10) (static nil) (margin '(25 55 25 35)))
    (apply #'twiddle :text text :static static :size size
                      :x x :y y  :margin margin args))

(defun print-copyrights ()
  (help-window (string-list-to-text (copyrights))
               :title "copyrights" :color 'white :menu nil))
  

(defun copyright-movie (&rest args &key (text (copyrights)) (size '(500 250))
                              (x 100) (y 25) (static nil) (margin '(15 45 15 45)))
  (let ((log)(twid))
    (when (and (boundp '*logo*) *logo*) (setf log *logo*))
    (setf twid (apply #'twiddle :text text :static static :size size
                      :x x :y y  :margin margin args))
    (when log (send log :close) (setf log nil))
    twid))

(defun appreciations () (credits-movie))

(defun credits-movie () 
  (when (and (boundp *logo*) *logo*) 
        (send *logo* :remove))
  (about-vista-with-logo))

(defun about-vista-movie () (about-vista-with-logo))

(defun haiku (&rest args) (apply #'zen-movie args))
(defun zen   (&rest args) (apply #'zen-movie args))


(defun close-remove ()
  (let* ((showing *desk-up*))
    (if *desk-up* (setf showing (send *desktop-container* :showing)))
    (send *vista* :dont-show-help-panel (not showing))))

(defmeth vista-system-object-proto  :dont-show-help-panel (&optional hidden)
  (let* ((text1 (send text-item-proto 
           :new (format nil "CLOSE OR REMOVE THE HELP PANEL?~2%CLOSE     - panel reappears next session.~%REMOVE - panel reappears when asked.")))
         (toggle (send toggle-item-proto :new "Show ViSta after Panel is Dismissed")) 
         (ok (send modal-button-proto :new "Close"
                   :action
                   (lambda ()
                     (send *help-control-panel* :remove)
                     (setf *help-control-panel* nil)
                     (setf *help-topics-panel* nil)
                     (if (send toggle :value)
                         (when hidden (show-vista))
                         (when hidden (exit)))
                     t)))
         (no (send modal-button-proto :new "Remove"
                   :action
                   (lambda ()
                     (send *help-control-panel* :remove)
                     (setf *help-control-panel* nil)
                     (setf *help-topics-panel* nil)
                     (send self :show-welcome nil)
                     (send self :show-first-help nil)
                     (if (send toggle :value)
                         (when hidden (show-vista))
                         (when hidden (exit)))
                     t)))
         (cancel (send modal-button-proto :new "Cancel"))
         (text2 (send text-item-proto 
                     :new "HELP TOPICS shows panel again."))
         (dialog (send modal-dialog-proto :new 
                       (remove 'nil
                         (list text1 (if hidden toggle) (list ok no cancel) text2))
                       :default-button ok
                       :title "What do you wish to do?")))
    (send dialog :modal-dialog)
    ))

(defun writing-spreadplots ()
  (file-to-window (strcat *help-dir-name* "sprdplot.hlp")
                  "About SpreadPlots" 
                  (send *vista* :help-window-object) t nil))


(defun writing-plugins ()
  (file-to-window (strcat *help-dir-name* "plugins.hlp")
                  "About Plugins" 
                  (send *vista* :help-window-object) t nil))

;fwy added following function 09-18-02
(defun writing-updates ()
  (file-to-window (strcat *help-dir-name* "updates.hlp")
                  "About Updates" 
                  (send *vista* :help-window-object) t nil))

(defun online-updates ()   (web-help "http://forrest.psych.unc.edu/research/vista-frames/updates/"))